<?php
add_action( 'cmb2_admin_init', 'nowwp_post_metaboxes' );
/**
 * Define the metabox and field configurations.
 */
function nowwp_post_metaboxes() {

	// Start with an underscore to hide fields from custom fields list
	$prefix = '_nowwp_';

	/**
	 * Metabox for Posts
	 */
	$cmb = new_cmb2_box( array(
		'id'            => 'post_metabox',
		'title'         => __( 'Post Options', 'nowwp' ),
		'object_types'  => array( 'post', ), // Post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // Keep the metabox closed by default
	) );

	$cmb->add_field( array(
		'name'    => 'Display Option',
		'id'      => $prefix . 'radio_display',
		'type'    => 'radio_inline',
		'options' => array(
			'text' => __( 'Box Overlay', 'nowwp' ),
			'bg'   => __( 'Full Background', 'nowwp' ),
		),
		'default' => 'bg',
	) );

	$cmb->add_field( array(
		'name'    => 'Copy Box on Left or Right',
		'id'      => $prefix . 'left_right',
		'type'    => 'radio_inline',
		'options' => array(
			'left' => __( 'Left', 'nowwp' ),
			'right'   => __( 'Right', 'nowwp' ),
		),
		'default' => 'left',
		'desc' => __( 'Only needed if using Box Overlay', 'nowwp' ),
	) );
}


add_action( 'cmb2_admin_init', 'nowwp_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function nowwp_register_taxonomy_metabox() {

	// Start with an underscore to hide fields from custom fields list
	$prefix = '_nowwp_';

	/**
	 * Metabox for categories and tags
	 */
	$cmb = new_cmb2_box( array(
		'id'               => $prefix . 'edit',
		'title'            => __( 'Category Metabox', 'nowwp' ), // Doesn't output for term boxes
		'object_types'     => array( 'term' ), // Tells CMB2 to use term_meta vs post_meta
		'taxonomies'       => array( 'category', 'post_tag' ), // Tells CMB2 which taxonomies should have these fields
		'new_term_section' => true, // Will display in the "Add New Category" section
	) );

	$cmb->add_field( array(
		'name'    => 'Background Image',
		'desc'    => 'Upload an image',
		'id'      =>  $prefix . 'cat_img',
		'type'    => 'file',
		// Optional:
		'options' => array(
			'url' => false, // Hide the text input for the url
		),
	) );
}

add_action( 'cmb2_admin_init', 'nowwp_register_user_profile_metabox' );
/**
 * Hook in and add a metabox to add fields to the user profile pages
 */
function nowwp_register_user_profile_metabox() {
	$prefix = 'nowwp_';
	/**
	 * Metabox for the user profile screen
	 */
	$cmb_user = new_cmb2_box( array(
		'id'               => $prefix . 'edit',
		'title'            => __( 'User Profile', 'nowwp' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta vs post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );
	$cmb_user->add_field( array(
		'name'     => __( 'Extra Info', 'nowwp' ),
		'desc'     => __( 'field description (optional)', 'nowwp' ),
		'id'       => $prefix . 'extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$cmb_user->add_field( array(
		'name'    => __( 'Background Image', 'nowwp' ),
		'desc'    => __( 'Upload an image', 'nowwp' ),
		'id'      => $prefix . 'author_bg',
		'type'    => 'file',
	) );
	$social_group = $cmb_user->add_field( array(
		'id'          => 'social_profiles',
		'type'        => 'group',
		'description' => __( 'Add social icons', 'cmb2' ),
		// 'repeatable'  => false, // use false if you want non-repeatable group
		'options'     => array(
			'group_title'   => __( 'Social Link {#}', 'cmb2' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => __( 'Add Another Social Profile', 'cmb2' ),
			'remove_button' => __( 'Remove Social Profile', 'cmb2' ),
			//'sortable'      => true, // beta
			// 'closed'     => true, // true to have the groups closed by default
		),
	) );

	// Id's for group's fields only need to be unique for the group. Prefix is not needed.
	$cmb_user->add_group_field( $social_group, array(
		'name' => 'Social Link',
		'id'   => 'link',
		'type' => 'text',
		// 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
	) );

	$cmb_user->add_group_field( $social_group, array(
		'name' => 'Icon',
		'description' => 'Use Font Awesome icons',
		'id'   => 'icon',
		'type' => 'text',
	) );
}

