<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package NowWP
 */

?>

<?php 
	// Get Featured Image URL
	$thumbnail = get_the_post_thumbnail_url();
	//Add classes to post_class
	$classes = array('col-md-12','col-lg-6','news');
	//Set background image
	$background = 'background: linear-gradient(rgba(0, 0, 0, 0), rgba(0, 0, 0, 0.6)), url(' . $thumbnail .') center center / cover no-repeat;';
	// Get which post display type
	$display_type = get_post_meta( get_the_ID(), '_nowwp_radio_display', true);
	// Text box on left or right side
	$left_right = get_post_meta( get_the_ID(), '_nowwp_left_right', true);

?>


<article id="post-<?php the_ID(); ?>" style="<?php echo $background; ?>" <?php post_class($classes); ?>>

	<div class="<?php echo $type = ($display_type == 'bg' ? 'image-bg' : 'text-overlay'); echo $lr = ($left_right == 'left' ? ' left' : ' right'); ?>">
		<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );?>
		<div class="entry-meta">
			<?php nowwp_posted_on(); ?>
		</div><!-- .entry-meta -->
	</div><!--  .image-bg/textoverlay --> 
	
</article><!-- #post-## -->

