<?php
/**
 * Template Name: Categories
 *
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package NowWP
 */

get_header(); ?>

	<?php
	    $args = array(
	      'orderby' => 'name',
	      'order' => 'ASC',
	      'parent' => 0,
	      );
		$categories = get_categories($args);
	?>

	<div id="primary" class="content-area container-fluid">
			<main id="main" class="site-main row" role="main">

			   <?php foreach($categories as $category) { 
			   		// Count Categories
				    $cat_count = sprintf( _n( '%s post', '%s posts', $category->count, 'nowwp' ), $category->count ); 
				    // Get the BG image
				    $cat_img = get_term_meta( $category->term_id, '_nowwp_cat_img', true );
				    // Setup some styles for the background
				    $background = 'background: linear-gradient(rgba(0, 0, 0, 0.45), rgba(0, 0, 0, 0.45)), url(' . $cat_img .') center center / cover no-repeat;';
				    // Check for the categories image
				    $header_style = ($cat_img  != '' ? $background : 'background: linear-gradient(#f96332 0%, #000 80%);');
				    ?>

				   <div class="col-md-6 col-lg-6 cat-item" style="<?php echo $header_style; ?>">
					   <div class="cat-body">
							   <h2 class="cat-title ">
								   <a href="<?php echo get_category_link( $category->term_id ); ?>" title="<?php echo $category->name ?>" >
								   	<?php echo $category->name; ?>
								   	</a>
							   	</h2>
							   <div class="cat-post"><?php echo $cat_count; ?></div>   
					   </div> <!-- cat-body-->
				    </div>  <!-- cat-item-->


			    <?php } ?>

	    </main><!-- main -->
    </div><!-- #primary -->



<?php
get_footer();