<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package NowWP
 */

get_header(); ?>


			<header class="page-header">
				<div class="container d-flex flex-column align-items-center justify-content-center">
					<?php
						the_archive_title( '<h1 class="page-title">', '</h1>' );
						the_archive_description( '<div class="archive-description">', '</div>' );
					?>
				</div><!--  .container -->
			</header><!-- .page-header -->

	
			<div id="primary" class="content-area container-fluid">
				<main id="main" class="site-main row" role="main">

				<?php
				if ( have_posts() ) : ?>

					

					<?php
					/* Start the Loop */
					while ( have_posts() ) : the_post();

						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						get_template_part( 'template-parts/content', 'news' );

					endwhile;

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif; ?>

				</main><!-- #main -->

				<?php 
					the_posts_pagination( array(
						'mid_size' => 5,
					    'prev_text' => '<i class="now-ui-icons arrows-1_minimal-left" aria-hidden="true"></i><span class="screen-reader-text">' . __( 'Previous Page', 'helpwp' ) . '</span>',
					    'next_text' => '<span class="screen-reader-text">' . __( 'Next Page', 'helpwp' ) . '</span><i class="now-ui-icons arrows-1_minimal-right" aria-hidden="true"></i>',
					) ); 
				 ?>
			</div><!-- #primary -->

<?php

get_footer();
