<?php
/**
 * NowWP Theme Customizer
 *
 * @package NowWP
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function nowwp_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
}
add_action( 'customize_register', 'nowwp_customize_register' );


if ( class_exists( 'Kirki' ) ) {
	/* Social Section */
	Kirki::add_section( 'social', array(
	    'title'          => __( 'Social' ),
	    'description'    => __( 'Social Icons' ),
	    'panel'          => '', // Not typically needed.
	    'priority'       => 160,
	    'capability'     => 'edit_theme_options',
	    'theme_supports' => '', // Rarely needed.
	) );

	Kirki::add_field( 'nowwp_theme', array(
		'type'        => 'switch',
		'settings'    => 'header_social',
		'label'       => __( 'Header Social Icons', 'nowwp' ),
		'section'     => 'social',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => array(
			'on'  => esc_attr__( 'Enable', 'nowwp' ),
			'off' => esc_attr__( 'Disable', 'nowwp' ),
		),
	) );

	Kirki::add_field( 'nowwp_theme', array(
		'type'        => 'switch',
		'settings'    => 'footer_social',
		'label'       => __( 'Footer Social Icons', 'nowwp' ),
		'section'     => 'social',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => array(
			'on'  => esc_attr__( 'Enable', 'nowwp' ),
			'off' => esc_attr__( 'Disable', 'nowwp' ),
		),
	) );

	/* Repeater - Social Icons */
	Kirki::add_field( 'nowwp_theme', array(
		'type'        => 'repeater',
		'label'       => esc_attr__( 'Social Repeater', 'nowwp' ),
		'section'     => 'social',
		'priority'    => 10,
		'row_label' => array(
			'type' => 'text',
			'value' => esc_attr__('Social Icon', 'nowwp' ),
		),
		'settings'    => 'sp_social',
		'default'     => array(
			array(
				'icon' => '',
				'url' => '',
			),
		),
		'fields' => array(
			'icon' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Font Awesome Icon', 'nowwp' ),
				'description' => esc_attr__( 'Icon for social link. ex: fa-facebook', 'nowwp' ),
				'default'     => '',
			),
			'url' => array(
				'type'        => 'text',
				'label'       => esc_attr__( 'Link to social profile', 'nowwp' ),
				'description' => esc_attr__( 'Start with https://', 'nowwp' ),
				'default'     => '',
			),
		)
	) );
}