<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package NowWP
 */

get_header(); ?>


			<div class="search-header">
				<header class="no-banner-page-header text-center">
					<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'nowwp' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
				</header><!-- .page-header -->
			</div><!--  .search-header -->

	
			<section id="primary" class="content-area container-fluid">
				<main id="main" class="site-main row" role="main">

				<?php
				if ( have_posts() ) : ?>

					<?php
					/* Start the Loop */
					while ( have_posts() ) : the_post();

						/**
						 * Run the loop for the search to output the results.
						 * If you want to overload this in a child theme then include a file
						 * called content-search.php and that will be used instead.
						 */
						get_template_part( 'template-parts/content', 'news' );

					endwhile;

					the_posts_navigation();

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif; ?>

				</main><!-- #main -->
			</section><!-- #primary -->

<?php
get_footer();
