<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package NowWP
 */

get_header(); ?>

	<?php
		while ( have_posts() ) : the_post();

			$thumbnail = get_the_post_thumbnail_url(); 
			$header_style = ($thumbnail  != '' ? 'background: url('. $thumbnail .')center center / cover no-repeat;' : '');
			?>

				<div class="page-header" style="<?php echo $header_style; ?>">
					<div class="container d-flex align-items-end">
						<header class="entry-header">
							<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
						</header><!-- .entry-header -->	
					</div><!--  .container -->
				</div><!--  .page-header -->

		<?php endwhile; // End of the loop.?>

	<?php rewind_posts(); ?>

	<div class="container">
		<div class="row">
			<div id="primary" class="content-area">
				<main id="main" class="site-main" role="main">

				<?php
				while ( have_posts() ) : the_post();

					get_template_part( 'template-parts/content', get_post_format() );

					the_post_navigation( array(
					    'prev_text' => '<i class="now-ui-icons arrows-1_minimal-left" aria-hidden="true"></i><span class="screen-reader-text">' . __( 'Previous Page', 'helpwp' ) . '</span>',
					    'next_text' => '<span class="screen-reader-text">' . __( 'Next Page', 'helpwp' ) . '</span><i class="now-ui-icons arrows-1_minimal-right" aria-hidden="true"></i>',
					) );

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				endwhile; // End of the loop.
				?>

				</main><!-- #main -->
			</div><!-- #primary -->
		</div>
	</div>

<?php
get_footer();
