<?php
/**
 * The template for displaying Categories
 *
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package NowWP
 */

get_header(); ?>

	<?php
		// Get category image 
		$cat_image = get_term_meta( $cat, '_nowwp_cat_img', true );
	?>

	<div class="page-header" style="background: url('<?php echo $cat_image; ?>') center center / cover no-repeat;">
		<div class="container d-flex align-items-center justify-content-center">
			<header class="entry-header">
					<h1><?php single_cat_title(); ?></h1>
					<?php echo category_description(); ?>
			</header><!-- .entry-header -->	
		</div><!--  .container -->
	</div><!--  .page-header -->

	
	<div id="primary" class="content-area container-fluid">
		<main id="main" class="site-main row" role="main">

			<?php
			/* Start the Loop */
			if ( have_posts() ) : 
			// Start counter	
			$i = 0;
			while ( have_posts() ) : the_post(); 

				// Get Featured Image URL
				$thumbnail = get_the_post_thumbnail_url();
				// Even or odd post
				$even_odd = ($i % 2 != 0 ? 'odd' : 'even' );
				//Add classes to post_class
				$classes = array('col-md-6','col-lg-3','news-cats', $even_odd);
				//Set background image
				$background = 'background: linear-gradient(rgba(0, 0, 0, 0), rgba(0, 0, 0, 0.6)), url(' . $thumbnail .') center center / cover no-repeat;';
				// Display the background
				$cat_bg = '<a href="'.get_permalink().'"><div class="post-background" style="'. $background .'"></div></a>';
			?>

				<article id="post-<?php the_ID(); ?>" <?php post_class($classes); ?>>
					<?php if($even_odd == 'even'){ echo $cat_bg; }; ?>
						<div class="text-overlay <?php echo $even_odd; ?>">
							<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );?>
							<div class="entry-meta">
								<?php nowwp_posted_on(); ?>
							</div><!-- .entry-meta -->
						</div><!--  .text-block -->
					<?php if($even_odd == 'odd') {echo $cat_bg; }; ?>
				</article><!-- #post-## -->

				<?php $i++; endwhile;

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif; ?>

		</main><!-- #main -->

		<?php 
				the_posts_pagination( array(
					'mid_size' => 5,
				    'prev_text' => '<i class="now-ui-icons arrows-1_minimal-left" aria-hidden="true"></i><span class="screen-reader-text">' . __( 'Previous Page', 'helpwp' ) . '</span>',
				    'next_text' => '<span class="screen-reader-text">' . __( 'Next Page', 'helpwp' ) . '</span><i class="now-ui-icons arrows-1_minimal-right" aria-hidden="true"></i>',
				) ); 
			 ?>
	</div><!-- #primary -->
		

<?php
get_footer();
