<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package NowWP
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">

	<header id="masthead" class="site-header" role="banner">
	    <nav class="navbar navbar-toggleable-md bg-primary fixed-top">
	    	
			   <div class="navbar-translate">
				<button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" data-target="#navigation" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-bar bar1"></span>
                    <span class="navbar-toggler-bar bar2"></span>
                    <span class="navbar-toggler-bar bar3"></span>
                </button>
				<?php if( has_custom_logo() ) { 
				  the_custom_logo(); 
					} else { ?>
					<div class="navbar-brand"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></div>
				<?php } ?>
				
				</div>
		   		<div class="collapse navbar-collapse justify-content-end" id="navigation" data-nav-image="<?php bloginfo('template_url'); ?>/images/blurred-image-1.jpg">
	            <?php
	            $args = array(
	              'theme_location' => 'primary',
	              'depth'      => 2,
	              'container'  => false,
	              'menu_class'     => 'navbar-nav',
	              'walker'     => new Bootstrap_Walker_Nav_Menu()
	              );
	            if (has_nav_menu('primary')) {
	              wp_nav_menu($args);
	            }
	            ?>

	            <?php $header_social = get_theme_mod( 'header_social', true );
		           if ($header_social == 1) : ?>
		            <span class="navbar-text d-flex align-items-center">
				      <?php get_template_part( 'template-parts/block', 'social' ); ?>
				    </span>
		          </div>
		      <?php endif; ?>

	        
		</nav>
	</header><!-- #masthead -->

	<div id="content" class="site-content">
