/*!

 =========================================================
 * Now-ui-kit - v1.0.0
 =========================================================

 * Product Page: https://www.creative-tim.com/product/now-ui-kit
 * Copyright 2017 Creative Tim (http://www.creative-tim.com)
 * Licensed under MIT (https://github.com/creativetimofficial/now-ui-kit/blob/master/LICENSE.md)

 * Designed by www.invisionapp.com Coded by www.creative-tim.com

 =========================================================

 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

 */

var transparent = true;

var transparentDemo = true;
var fixedTop = false;

var navbar_initialized,
    backgroundOrange = false,
    toggle_initialized = false;

jQuery(document).ready(function($){
    //  Activate the Tooltips
    jQuery('[data-toggle="tooltip"], [rel="tooltip"]').tooltip();

    // Activate Popovers and set color for popovers
    jQuery('[data-toggle="popover"]').each(function(){
        color_class = jQuery(this).data('color');
        jQuery(this).popover({
            template: '<div class="popover '+ color_class +' " role="tooltip"><h3 class="popover-title"></h3><div class="popover-content"></div></div>'
        });
    });

    $navbar = jQuery('.navbar[color-on-scroll]');
    scroll_distance = $navbar.attr('color-on-scroll') || 500;

    // Check if we have the class "navbar-color-on-scroll" then add the function to remove the class "navbar-transparent" so it will transform to a plain color.

    if(jQuery('.navbar[color-on-scroll]').length !== 0){
        nowuiKit.checkScrollForTransparentNavbar();
        jQuery(window).on('scroll', nowuiKit.checkScrollForTransparentNavbar);
    }

    jQuery('.form-control').on("focus", function(){
        jQuery(this).parent('.input-group').addClass("input-group-focus");
    }).on("blur", function(){
        jQuery(this).parent(".input-group").removeClass("input-group-focus");
    });

    // Activate bootstrapSwitch
    jQuery('.bootstrap-switch').each(function(){
        $this = jQuery(this);
        data_on_label = $this.data('on-label') || '';
        data_off_label = $this.data('off-label') || '';

        $this.bootstrapSwitch({
            onText: data_on_label,
            offText: data_off_label
        });
    });

    if( jQuery(window).width() < 992 ){
        nowuiKit.initRightMenu();
    }

    if (jQuery(window).width() >= 992){
        big_image = jQuery('.page-header-image[data-parallax="true"]');

        jQuery(window).on('scroll', nowuiKitDemo.checkScrollForParallax);
    }

    // Activate Carousel
    jQuery('.carousel').carousel({
        interval: 4000
    });

    jQuery('.date-picker').each(function(){
        jQuery(this).datepicker({
            templates:{
                leftArrow: '<i class="now-ui-icons arrows-1_minimal-left"></i>',
                rightArrow: '<i class="now-ui-icons arrows-1_minimal-right"></i>'
            }
        }).on('show', function() {
                jQuery('.datepicker').addClass('open');

                datepicker_color = jQuery(this).data('datepicker-color');
                if( datepicker_color.length !== 0){
                    jQuery('.datepicker').addClass('datepicker-'+ datepicker_color +'');
                }
            }).on('hide', function() {
                jQuery('.datepicker').removeClass('open');
            });
    });


});


jQuery(window).resize(function($){
    if( jQuery(window).width() < 992 ){
        nowuiKit.initRightMenu();
    }
});

nowuiKit = {
    misc:{
        navbar_menu_visible: 0
    },

    checkScrollForTransparentNavbar: debounce(function() {
            if(jQuery(document).scrollTop() > scroll_distance ) {
                if(transparent) {
                    transparent = false;
                    jQuery('.navbar[color-on-scroll]').removeClass('navbar-transparent');
                }
            } else {
                if( !transparent ) {
                    transparent = true;
                    jQuery('.navbar[color-on-scroll]').addClass('navbar-transparent');
                }
            }
    }, 17),

    initRightMenu: function(){
        if(!toggle_initialized){
            $toggle = jQuery('.navbar-toggler');

            $toggle.click(function (){
                if(nowuiKit.misc.navbar_menu_visible == 1) {
                    jQuery('html').removeClass('nav-open');
                   nowuiKit.misc.navbar_menu_visible = 0;
                    setTimeout(function(){
                       $toggle.removeClass('toggled');
                       jQuery('#bodyClick').remove();
                   }, 550);

                } else {

                   setTimeout(function(){
                       $toggle.addClass('toggled');
                   }, 580);

                   $navbar = jQuery(this).parent('.navbar-translate').siblings('.navbar-collapse');
                   background_image = $navbar.data('nav-image');
                   if(background_image !== undefined){
                      $navbar.css('background',"url('" + background_image + "')")
                             .removeAttr('data-nav-image')
                             .css('background-size',"cover")
                             .addClass('has-image');
                   }

                   div = '<div id="bodyClick"></div>';
                   jQuery(div).appendTo('body').click(function() {
                       jQuery('html').removeClass('nav-open');
                       nowuiKit.misc.navbar_menu_visible = 0;
                        setTimeout(function(){
                           $toggle.removeClass('toggled');
                           jQuery('#bodyClick').remove();
                        }, 550);
                   });

                  jQuery('html').addClass('nav-open');
                   nowuiKit.misc.navbar_menu_visible = 1;

                }
            });
            toggle_initialized = true;
        }
    },

    initSliders: function(){
        // Sliders for demo purpose in refine cards section
        var slider = document.getElementById('sliderRegular');

        noUiSlider.create(slider, {
            start: 40,
            connect: [true,false],
            range: {
                min: 0,
                max: 100
            }
        });

        var slider2 = document.getElementById('sliderDouble');

        noUiSlider.create(slider2, {
            start: [ 20, 60 ],
            connect: true,
            range: {
                min:  0,
                max:  100
            }
        });
    }
};


var big_image;

// Javascript just for Demo purpose, remove it from your project
nowuiKitDemo = {
    checkScrollForParallax: debounce(function(){
        var current_scroll = jQuery(this).scrollTop();

        oVal = (jQuery(window).scrollTop() / 3);
        big_image.css({
            'transform':'translate3d(0,' + oVal +'px,0)',
            '-webkit-transform':'translate3d(0,' + oVal +'px,0)',
            '-ms-transform':'translate3d(0,' + oVal +'px,0)',
            '-o-transform':'translate3d(0,' + oVal +'px,0)'
        });

    }, 6)

};

// Returns a function, that, as long as it continues to be invoked, will not
// be triggered. The function will be called after it stops being called for
// N milliseconds. If `immediate` is passed, trigger the function on the
// leading edge, instead of the trailing.

function debounce(func, wait, immediate) {
    var timeout;
    return function() {
        var context = this, args = arguments;
        clearTimeout(timeout);
        timeout = setTimeout(function() {
            timeout = null;
            if (!immediate) func.apply(context, args);
        }, wait);
        if (immediate && !timeout) func.apply(context, args);
    };
}