<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package NowWP
 */

get_header(); ?>

	<?php
		while ( have_posts() ) : the_post();

			$thumbnail = get_the_post_thumbnail_url(); 
			$header_style = ($thumbnail  != '' ? 'background: url('. $thumbnail .') center center / cover no-repeat;' : '');
			?>

			<div class="page-header" style="<?php echo $header_style; ?>">
				<div class="container d-flex align-items-end">
					<header class="entry-header">
						<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
					</header><!-- .entry-header -->	
				</div><!--  .container -->
			</div><!--  .page-header -->

		<?php endwhile; // End of the loop.?>

	<?php rewind_posts(); ?>

	<div class="container">
		<div class="row">
			<div id="primary" class="content-area">
				<main id="main" class="site-main" role="main">

					<?php
					while ( have_posts() ) : the_post();

						get_template_part( 'template-parts/content', 'page' );

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>

				</main><!-- #main -->
			</div><!-- #primary -->
		</div>
	</div>

<?php
get_footer();
