<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://mvpwp.com
 * @since             1.0.0
 * @package           MVPWP_CPT_Plugin
 *
 * @wordpress-plugin
 * Plugin Name:       MVPWP CPT Plugin
 * Plugin URI:        http://mvpwp.com
 * Description:       Custom Post Type Plugin
 * Version:           1.0.0
 * Author:            Brad Williams
 * Author URI:        http://braginteractive.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       mvpwp
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

final class MVPWP_CPT_Plugin {

	/**
	 * @var MVPWP_CPT_Plugin.
	 * @since 1.4
	 */
	private static $instance;


	/**
	 * Main MVPWP_CPT_Plugin Instance
	 *
	 * Insures that only one instance of MVPWP_CPT_Plugin exists in memory at any one
	 * time. Also prevents needing to define globals all over the place.
	 *
	 * @since 1.4
	 * @static
	 * @staticvar array $instance
	 * @uses MVPWP_CPT_Plugin::setup_constants() Setup the constants needed
	 * @uses MVPWP_CPT_Plugin::includes() Include the required files
	 * @uses MVPWP_CPT_Plugin::load_textdomain() load the language files
	 * @see MVPWP_CPT_Plugin()
	 * @return The one true MVPWP_CPT_Plugin
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof MVPWP_CPT_Plugin ) ) {
			self::$instance = new MVPWP_CPT_Plugin;
			self::$instance->setup_constants();

			add_action( 'plugins_loaded', array( self::$instance, 'load_textdomain' ) );

			self::$instance->includes();
		}
		return self::$instance;
	}

	/**
	 * Setup plugin constants
	 *
	 * @access private
	 * @since 1.4
	 * @return void
	 */
	private function setup_constants() {

		// Plugin version
		if ( ! defined( 'MVPWP_CPT_PLUGIN_VERSION' ) ) {
			define( 'MVPWP_CPT_PLUGIN_VERSION', '1.0.0' );
		}

		// Plugin Folder Path
		if ( ! defined( 'MVPWP_CPT_PLUGIN_PLUGIN_DIR' ) ) {
			define( 'MVPWP_CPT_PLUGIN_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
		}

		// Plugin Folder URL
		if ( ! defined( 'MVPWP_CPT_PLUGIN_PLUGIN_URL' ) ) {
			define( 'MVPWP_CPT_PLUGIN_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
		}

		// Plugin Root File
		if ( ! defined( 'MVPWP_CPT_PLUGIN_PLUGIN_FILE' ) ) {
			define( 'MVPWP_CPT_PLUGIN_PLUGIN_FILE', __FILE__ );
		}
	}

	/**
	 * Include required files
	 *
	 * @access private
	 * @since 1.0.0
	 * @return void
	 */
	private function includes() {

    require_once MVPWP_CPT_PLUGIN_PLUGIN_DIR . 'includes/cpt.php';

	}

	/**
	 * Loads the plugin language files
	 *
	 * @access public
	 * @since 1.0.0
	 * @return void
	 */
	public function load_textdomain() {
		// Set filter for plugin's languages directory
		$plugin_name_lang_dir = dirname( plugin_basename( MVPWP_CPT_PLUGIN_PLUGIN_FILE ) ) . '/languages/';
		$plugin_name_lang_dir = apply_filters( 'plugin_name_languages_directory', $plugin_name_lang_dir );

		// Traditional WordPress plugin locale filter
		$locale        = apply_filters( 'plugin_locale',  get_locale(), 'mvpwp' );
		$mofile        = sprintf( '%1$s-%2$s.mo', 'mvpwp', $locale );

		// Setup paths to current locale file
		$mofile_local  = $plugin_name_lang_dir . $mofile;

		if ( file_exists( $mofile_local ) ) {
			// Look in local /wp-content/plugins/mvpwp/languages/ folder
			load_textdomain( 'mvpwp', $mofile_local );
		} else {
			// Load the default language files
			load_plugin_textdomain( 'mvpwp', false, $plugin_name_lang_dir );
		}
	}
}


/**
 * The main function responsible for returning the one true MVPWP_CPT_Plugin
 * Instance to functions everywhere.
 *
 * Use this function like you would a global variable, except without needing
 * to declare the global.
 *
 *
 * @since 1.0.0
 * @return object The one true MVPWP_CPT_Plugin Instance
 */

function MVPWP_CPT_Plugin() {
	return MVPWP_CPT_Plugin::instance();
}

// Get MVPWP_CPT_Plugin Running
MVPWP_CPT_Plugin();
